#include <iostream>
#include <vector>
#include <map>
#include <string>
#include <sstream>

using namespace std;

vector<int> p;
map<int, vector<int>> place;

void swap(int a, int b) {
	int tmp = p[a];
	p[a] = p[b];
	p[b] = tmp;
}

int searchforpath_(int srcd, int source, int distance) {
	if (srcd == source)
		return distance;
	else {
		int i;
		for (i = 0; i < place[source].size(); i++) {
			if (source != place[source][i])
				if(place[source].size() != 1 && place[source][0] == source)
					return searchforpath_(srcd, place[source][i], distance + 1);
		}
	}
}

int searchforpath(int start, int trazen) {
	return searchforpath_(trazen, start, 0);
}

int furthest(int src, int l, int d) {
	int i;
	int maxdst = 0;
	int ret = 0;
	for (i = l - 1; i < d; i++) {
		int dst = searchforpath(src, p[l]);
		if (dst > maxdst) 
			maxdst = dst;
	}
	return maxdst;
}

int main() {
	ios_base::sync_with_stdio(false);

	int n; cin >> n;
	p.resize(n);
	int i;
	for (i = 0; i < n; i++) {
		cin >> p[i];
		place.insert({ p[i], {} });
	}
	for (i = 0; i < n - 1; i++) {
		int a, b;
		cin >> a >> b;
		place[a].push_back(b);
		place[b].push_back(a);
	}

	int q; cin >> q;
	vector<int> response;
	for (i = 0; i < q; i++) {
		string input;
		getline(cin, input, '\n');
		istringstream tmp(input);
		int first;
		tmp >> first;
		if (first == 1) {
			int a, b;
			tmp >> a;
			tmp >> b;
			swap(a, b);
		}
		else {
			int l, r, x;
			tmp >> l;
			tmp >> r; 
			tmp >> x;
			response.push_back(furthest(x, l, r));
		}
	}
	for (i = 0; i < response.size(); i++)
		cout << response[i] << "\n";
	return 0;
}